package org.msh.tb.bd.dashboard.summaryrep.data;

/**
 * Created by mauri on 29/05/2017.
 * Data object to store information about each rate inside an indicator
 */
public class IndicatorRateData {
    /**
     * Rate number (population, percentage...)
     */
    private Float rate;

    /**
     * The rate suffix (%, : 1...)
     */
    private String rateSuffix;

    /**
     * The rate description message key
     */
    private String rateDescMsg;

    /**
     * The national result for comparison
     */
    private Float nationalRate;

    public IndicatorRateData() {
        super();
    }

    public IndicatorRateData(Float rate, String rateSuffix, String rateDescMsg) {
        this.rate = rate;
        this.rateSuffix = rateSuffix;
        this.rateDescMsg = rateDescMsg;
    }

    public Float getRate() {
        return rate;
    }

    public void setRate(Float rate) {
        this.rate = rate;
    }

    public String getRateSuffix() {
        return rateSuffix;
    }

    public void setRateSuffix(String rateSuffix) {
        this.rateSuffix = rateSuffix;
    }

    public String getRateDescMsg() {
        return rateDescMsg;
    }

    public void setRateDescMsg(String rateDescMsg) {
        this.rateDescMsg = rateDescMsg;
    }

    public Float getNationalRate() {
        return nationalRate;
    }

    public void setNationalRate(Float nationalRate) {
        this.nationalRate = nationalRate;
    }
}
